import { Injectable } from "@angular/core";
import { Router, ActivatedRoute, NavigationEnd } from "@angular/router";

@Injectable()
export class ActiveState {

  public name: string;

  constructor(router: Router, route: ActivatedRoute) {
    // https://stackoverflow.com/a/41527584/132074
    router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {

        // Traverse the active route tree
        let snapshot = route.snapshot;
        let activated = route.firstChild;
        if (activated != null) {
          while (activated != null) {
            snapshot = activated.snapshot;
            activated = activated.firstChild;
          }
        }
        this.name = snapshot.data['stateName'] || "unnamed";
      }
    });
  }

  is(name: string): boolean {
    return this.name === name;
  }

  get whereAmI(): string {
    return `MCCF EDI TAS Portal Home Page > ${this.name}`
  }
}
